	function PLOT_PHASE_Z_14_14(wT, H0, H1, H2 ,H3, H4)
 
	% Plots the phase response for a polyphase IIR filter for Example 14.14.
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2016-05-07
	% Modified by: 	 
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs:	 
	% Report bugs to:	Wanhammar@gmail.com

	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================			
	Phase0 = unwrap(angle(H0));
	plot(wT, Phase0,'linewidth',lw), grid on, hold on
	Phase1 = unwrap(angle(H1));
	plot(wT, Phase1,'linewidth',lw), hold on
	Phase2 = unwrap(angle(H2));
	plot(wT, Phase2,'linewidth',lw), hold on
	Phase3 = unwrap(angle(H3));
	plot(wT, Phase3,'linewidth',lw), hold on
	Phase4 = unwrap(angle(H4));
	plot(wT, Phase4,'linewidth',lw)	
	axis([0 pi -15*pi 0]);
	ylabel('{\it\Phi}({\ite^j^\omega^T}) [rad]','FontName', fn,'FontSize',fs);	
	xlabel('{\it\omegaT}  [rad]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};
	xtick(ax,lab);	
	ay = [-15*pi -10*pi -5*pi 0];
	laby = {'-15\pi';' ';' ';'0'};
	ytick(ay,laby); 
